/** @file   proctorai.cpp
 * @brief   Implementation of ProctorAI class.
 * @version $Revision: 1.4 $
 * @date    $Date: 2006/04/03 20:58:01 $
 * @author  Tomi Lamminsaari
 */


#include "proctorai.h"
#include "www_assert.h"
#include "warglobals.h"
#include "utils.h"
using namespace eng2d;

namespace WeWantWar {



const float ProctorAI::SHOOT_DISTANCE = 400;

// class constructor
ProctorAI::ProctorAI( GameObject* pAlien ) :
  AIController( pAlien, WarGlobals::pObjTable->pPlayer ),
  
  m_alerted( false )
{
  AIController::m_visualRange = 700;
  AIController::m_attackRange = 400;
  this->setFlags( AIController::WAIT_TARGET );
	WWW_ASSERT( WarGlobals::pObjTable->pPlayer != 0 );
	WWW_ASSERT( pAlien != 0 );
}

// class destructor
ProctorAI::~ProctorAI()
{
	
}



/** Updates the controlling commands
 */
void ProctorAI::updateAI( bool seeTarget, float dist )
{
  bool withinRange = this->withinAttackRange();
  bool weaponReady = !m_pObject->reloading();
  bool facingTarget = Utils::isFacingObject( m_pObject, m_pTarget, 20 );
  Vec2D ourPos = m_pObject->position();
  Vec2D targetPos = m_pTarget->position();
  int ourAngle = m_pObject->angle();
  
  if ( m_alerted == false ) {
    if ( seeTarget == true ) {
      m_alerted = true;
    } else {
      // We haven't seen player yet, so we stay put
      this->reset();
      this->setCounter( 5 + rand() % 5 );
      return;
    }
  }
  this->setRandomMovement( 10 + rand() % 10 );
  
  if ( seeTarget == true ) {
    if ( withinRange == true ) {
      if ( facingTarget == true ) {
        if ( weaponReady == true ) {
          // We're ready to shoot.
          this->reset();
          this->shoot() = 1;
          this->setCounter( 35 );
          return;
        } else {
          // We're pointing to the target but our gun is not ready.
          this->setRandomMovement( 12 + (rand()%15) );
          this->avoidWalls();
          return;
        }
        
      } else {
        // We're not facing the target. Keep turning towards him.
        this->reset();
        this->forward() = 1;
        int d = Utils::findTurningDir( ourPos, targetPos, ourAngle );
        this->turn() = 2*d;
        if ( dist < 80 ) {
          this->forward() = 0;
          this->turn() = 4*d;  // turn more quickly
        }
        this->avoidWalls();
        return;
      }
      
    } else {
      // We're not within the range. Get closer. Use A* algorithm to find path
      // to the player.
      AStarAlgorithm algo( *this );
      algo.SetMaxRouteNodes( 64 );
      bool pathFound = algo.FindPath( ourPos, targetPos );
      const MPathFinderAlgo::NodeArray& nodes = algo.GetPathNodes();
      if ( pathFound == true && nodes.size() > 2 ) {
        // We found the route.
        Vec2D nodePos( nodes.at(1) );
        int d = Utils::findTurningDir( ourPos, nodePos, ourAngle );
        this->reset();
        this->forward() = 1;
        this->turn() = 2*d;
        this->setCounter( 4 + rand() % 3 );
        return;
      } else {
        // No path from our current position to the player. Move randomly.
        return;
      }
    }
  } else {
    // We don't see the target.
    AStarAlgorithm algo( *this );
    algo.SetMaxRouteNodes( 64 );
    bool pathFound = algo.FindPath( ourPos, targetPos );
    const MPathFinderAlgo::NodeArray& nodes = algo.GetPathNodes();
    if ( pathFound == true && nodes.size() > 2 ) {
      Vec2D nodePos( nodes.at(1) );
      int d = Utils::findTurningDir( ourPos, nodePos, ourAngle );
      this->reset();
      this->forward() = 1;
      this->turn() = 2*d;
      this->setCounter( 4 + rand() % 3 );
      return;
    } else {
      // No path to the target. Move randomly.
      return;
    }
  }
}



/** Sets the alerted-flag.
 */
void ProctorAI::setAlerted( bool alerted )
{
  m_alerted = alerted;
  AIController::m_flags &= ~AIController::WAIT_TARGET;
}

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: proctorai.cpp,v $
 * Revision 1.4  2006/04/03 20:58:01  lamminsa
 * Lesser route nodes.
 *
 * Revision 1.3  2006/02/26 07:37:12  lamminsa
 * New logic.
 *
 * Revision 1.2  2006/02/24 12:27:58  lamminsa
 * no message
 *
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:37+02  lamminsa
 * Initial revision
 *
 */
 
